#from . import doocsmy as doocspie
import doocspie


class IOService:
    class IOException(Exception):
        def __init__(self, error):
            super().__init__("I/O error: " + error)

    @classmethod
    def _get(cls, address):
        try:
            return doocspie.get(address)
        except Exception as exc:
            raise cls.IOException(str(exc))

    def __init__(self, image_data, encoder_data):
        self._image_data = image_data
        self._encoder_data = encoder_data

    @property
    def image_data(self):
        return self._image_data

    @property
    def cameras(self):
        return self._image_data.cameras

    def use_camera(self, camera):
        self._image_data.use_camera(camera)

    def update(self):
        self._image_data.update(self._get(self._image_data.address))
        if self._image_data.use_encoder:
            self._encoder_data.update(self._get(self._encoder_data.address))

    def is_new_data_available(self):
        return self._image_data.is_new_data_available
