from collections import namedtuple


class MetricsData:
    _Metrics = namedtuple("Metrics", ("horizontal", "vertical"))
    _Values = namedtuple("Values", ("center", "fwhm", "amplitude"))
    _Units = namedtuple("Units", ("center", "fwhm", "amplitude"))

    def __init__(self):
        self._metrics_values = self._Metrics(self._Values([], [], []), self._Values([], [], []))
        self._metrics_units = self._Metrics(self._Units("px", "px", "arb. u."), self._Units("px", "px", "arb. u."))
        self._metrics_values_calibrated_in_nm = self._Metrics(self._Values([], [], []), self._Values([], [], []))
        self._metrics_units_calibrated_in_nm = self._Metrics(self._Units("nm", "nm", "arb. u."),
                                                             self._Units("px", "px", "arb. u."))
        self._metrics_values_calibrated_in_ev = self._Metrics(self._Values([], [], []), self._Values([], [], []))
        self._metrics_units_calibrated_in_ev = self._Metrics(self._Units("eV", "eV", "arb. u."),
                                                             self._Units("px", "px", "arb. u."))

    @property
    def metrics_values(self):
        return self._metrics_values

    @property
    def metrics_units(self):
        return self._metrics_units

    @property
    def metrics_values_calibrated_in_nm(self):
        return self._metrics_values_calibrated_in_nm

    @property
    def metrics_units_calibrated_in_nm(self):
        return self._metrics_units_calibrated_in_nm

    @property
    def metrics_values_calibrated_in_ev(self):
        return self._metrics_values_calibrated_in_ev

    @property
    def metrics_units_calibrated_in_ev(self):
        return self._metrics_units_calibrated_in_ev

    def update(self, metrics_horizontal, metrics_vertical):
        self._update(self._metrics_values, metrics_horizontal, metrics_vertical)

    def update_calibrated_in_nm(self, metrics_horizontal, metrics_vertical):
        self._update(self._metrics_values_calibrated_in_nm, metrics_horizontal, metrics_vertical)

    def update_calibrated_in_ev(self, metrics_horizontal, metrics_vertical):
        self._update(self._metrics_values_calibrated_in_ev, metrics_horizontal, metrics_vertical)

    @staticmethod
    def _update(metrics, metrics_horizontal, metrics_vertical):
        metrics.horizontal.center.append(metrics_horizontal.center)
        metrics.horizontal.fwhm.append(metrics_horizontal.fwhm)
        metrics.horizontal.amplitude.append(metrics_horizontal.amplitude)
        metrics.vertical.center.append(metrics_vertical.center)
        metrics.vertical.fwhm.append(metrics_vertical.fwhm)
        metrics.vertical.amplitude.append(metrics_vertical.amplitude)

    def reset(self):
        self._reset(self._metrics_values)
        self._reset(self._metrics_values_calibrated_in_nm)
        self._reset(self._metrics_values_calibrated_in_ev)

    @staticmethod
    def _reset(metrics):
        metrics.horizontal.center.clear()
        metrics.horizontal.fwhm.clear()
        metrics.horizontal.amplitude.clear()
        metrics.vertical.center.clear()
        metrics.vertical.fwhm.clear()
        metrics.vertical.amplitude.clear()
