import configparser


class ROIData:
    _POSITION = "position"
    _SIZE = "size"

    def __init__(self, resources_path, cameras):
        self._resources_path = resources_path
        self._cameras = cameras
        self._file = None
        self._config = configparser.ConfigParser()
        self._position = None
        self._size = None

    @property
    def position(self):
        return self._position

    @property
    def size(self):
        return self._size

    def use_camera(self, checked_camera):
        self._file = self._resources_path + self._cameras[checked_camera]["roi_file"]
        self._update_config()

    def _update_config(self):
        self._config.clear()
        self._config.read(self._file)

        self._position = dict(self._config.items(self._POSITION))
        self._size = dict(self._config.items(self._SIZE))

    def save(self):
        for key, value in self._position.items():
            self._config[self._POSITION][key] = str(value)

        for key, value in self._size.items():
            self._config[self._SIZE][key] = str(value)

        with open(self._file, "w+", encoding="UTF-8") as roi_file:
            self._config.write(roi_file)
