from PyQt5.QtWidgets import QMainWindow, QVBoxLayout, QWidget, QAction, QTabWidget, QActionGroup

from doocspie.pyqt import messages


class SpectralyzerToolUi(QMainWindow):

    def __init__(self, application_name, version, cameras, calibration_menu_items, *tool_uis):
        super().__init__()
        self._application_name = application_name
        self._version = version
        self._cameras = cameras
        self._calibration_menu_items = calibration_menu_items
        self._tool_uis = tool_uis
        self._main_layout = QVBoxLayout()
        self._print_to_e_log_action = QAction("Print to E-Log")
        self._camera_menu = None
        self._camera_menu_action_group = None
        self._enable_calibration_action = QAction("Enable", checkable=True, checked=True)
        self._change_calibration_action = QAction("Change")
        self._calibration_menu_action_group = None
        self._click_about_action = QAction("About")
        self._tab_widget = QTabWidget()
        self._create_layout()
        self._create_connections()

    def _create_layout(self):
        self._create_main_layout()
        self._create_menu_bar()
        self._create_tools_tab_widget()

    def _create_main_layout(self):
        main_widget = QWidget()
        main_widget.setLayout(self._main_layout)
        self.setCentralWidget(main_widget)

    def _create_menu_bar(self):
        self._create_file_menu()
        self._create_camera_menu()
        self._create_calibration_menu()
        self._create_help_menu()

    def _create_file_menu(self):
        self.menuBar().addMenu("File").addAction(self._print_to_e_log_action)

    def _create_camera_menu(self):
        self._camera_menu = self.menuBar().addMenu("Camera")
        self._camera_menu_action_group = QActionGroup(self._camera_menu)
        for index, menu_item in enumerate(self._cameras):
            q_action = QAction(menu_item, checkable=True)
            if index == 0:
                q_action.setChecked(True)
            self._camera_menu.addAction(self._camera_menu_action_group.addAction(q_action))

    def _create_calibration_menu(self):
        calibration_menu = self.menuBar().addMenu("Calibration")
        calibration_menu.addAction(self._enable_calibration_action)
        calibration_menu.addAction(self._change_calibration_action)
        calibration_menu.addSeparator()
        self._calibration_menu_action_group = QActionGroup(calibration_menu)
        for index, menu_item in enumerate(self._calibration_menu_items):
            q_action = QAction(menu_item, checkable=True)
            if index == 0:
                q_action.setChecked(True)
            calibration_menu.addAction(self._calibration_menu_action_group.addAction(q_action))

    def _create_help_menu(self):
        self.menuBar().addMenu("Help").addAction(self._click_about_action)

    def _create_tools_tab_widget(self):
        for tool_ui in self._tool_uis:
            self._tab_widget.addTab(tool_ui, tool_ui.name)
        self._main_layout.addWidget(self._tab_widget)

    def _create_connections(self):
        self._click_about_action.triggered.connect(
            lambda: messages.show_about(self, self._application_name, self._version))

    @property
    def application_name(self):
        return self._application_name

    @property
    def version(self):
        return self._version

    @property
    def print_to_e_log_action(self):
        return self._print_to_e_log_action

    @property
    def camera_menu_action_group(self):
        return self._camera_menu_action_group

    @property
    def camera_menu(self):
        return self._camera_menu

    @property
    def enable_calibration_action(self):
        return self._enable_calibration_action

    @property
    def change_calibration_action(self):
        return self._change_calibration_action

    @property
    def calibration_menu_action_group(self):
        return self._calibration_menu_action_group

    @property
    def tab_widget(self):
        return self._tab_widget

    def get_checked_camera(self):
        return self._camera_menu_action_group.checkedAction().text()

    def get_checked_calibration(self):
        return self._calibration_menu_action_group.checkedAction().text()

    def get_current_ui(self):
        return self._tab_widget.currentWidget()

    def show_window(self):
        self.show()
        self.setMinimumSize(self.width(), self.height())
