class MetricsService:

    def __init__(self, metrics_data, fit_data):
        self._metrics_data = metrics_data
        self._fit_data = fit_data

    @property
    def metrics_data(self):
        return self._metrics_data

    def update(self):
        self._metrics_data.update(self._fit_data.parameters.horizontal, self._fit_data.parameters.vertical)
        self._metrics_data.update_calibrated_in_nm(self._fit_data.parameters_calibrated_in_nm.horizontal,
                                                   self._fit_data.parameters_calibrated_in_nm.vertical)
        self._metrics_data.update_calibrated_in_ev(self._fit_data.parameters_calibrated_in_ev.horizontal,
                                                   self._fit_data.parameters_calibrated_in_ev.vertical)
