from collections import namedtuple

import numpy as np


class FitData:
    _Fits = namedtuple("Fits", ("horizontal", "vertical"))
    _Data = namedtuple("Data", ("x", "y"))
    _Parameters = namedtuple("Parameters", ["offset", "slope", "amplitude", "center", "fwhm"])

    def __init__(self):
        self._fits_single = None
        self._fits = None
        self._fits_calibrated_in_nm_single = None
        self._fits_calibrated_in_nm = None
        self._fits_calibrated_in_ev_single = None
        self._fits_calibrated_in_ev = None
        self._parameters_single = None
        self._parameters = None
        self._parameters_calibrated_in_nm_single = None
        self._parameters_calibrated_in_nm = None
        self._parameters_calibrated_in_ev_single = None
        self._parameters_calibrated_in_ev = None
        self._parameters_train = None

    @property
    def fits_single(self):
        return self._fits_single

    @property
    def fits(self):
        return self._fits

    @property
    def fits_calibrated_in_nm_single(self):
        return self._fits_calibrated_in_nm_single

    @property
    def fits_calibrated_in_nm(self):
        return self._fits_calibrated_in_nm

    @property
    def fits_calibrated_in_ev_single(self):
        return self._fits_calibrated_in_ev_single

    @property
    def fits_calibrated_in_ev(self):
        return self._fits_calibrated_in_ev

    @property
    def parameters_single(self):
        return self._parameters_single

    @property
    def parameters(self):
        return self._parameters

    @property
    def parameters_calibrated_in_nm_single(self):
        return self._parameters_calibrated_in_nm_single

    @property
    def parameters_calibrated_in_nm(self):
        return self._parameters_calibrated_in_nm

    @property
    def parameters_calibrated_in_ev_single(self):
        return self._parameters_calibrated_in_ev_single

    @property
    def parameters_calibrated_in_ev(self):
        return self._parameters_calibrated_in_ev

    def update_single(self, horizontal_fit, horizontal_fit_parameters, vertical_fit, vertical_fit_parameters):
        self._update_fits_single(horizontal_fit, vertical_fit)
        self._update_fit_parameters_single(horizontal_fit_parameters, vertical_fit_parameters)

    def update(self, horizontal_fit, horizontal_fit_parameters, vertical_fit, vertical_fit_parameters):
        self._update_fits(horizontal_fit, vertical_fit)
        self._update_fit_parameters(horizontal_fit_parameters, vertical_fit_parameters)

    def update_calibrated_in_nm_single(self, horizontal_fit, horizontal_fit_parameters, vertical_fit,
                                       vertical_fit_parameters):
        self._update_fits_calibrated_in_nm_single(horizontal_fit, vertical_fit)
        self._update_fit_parameters_calibrated_in_nm_single(horizontal_fit_parameters, vertical_fit_parameters)

    def update_calibrated_in_nm(self, horizontal_fit, horizontal_fit_parameters, vertical_fit, vertical_fit_parameters):
        self._update_fits_calibrated_in_nm(horizontal_fit, vertical_fit)
        self._update_fit_parameters_calibrated_in_nm(horizontal_fit_parameters, vertical_fit_parameters)

    def update_calibrated_in_ev_single(self, horizontal_fit, horizontal_fit_parameters, vertical_fit,
                                       vertical_fit_parameters):
        self._update_fits_calibrated_in_ev_single(horizontal_fit, vertical_fit)
        self._update_fit_parameters_calibrated_in_ev_single(horizontal_fit_parameters, vertical_fit_parameters)

    def update_calibrated_in_ev(self, horizontal_fit, horizontal_fit_parameters, vertical_fit, vertical_fit_parameters):
        self._update_fits_calibrated_in_ev(horizontal_fit, vertical_fit)
        self._update_fit_parameters_calibrated_in_ev(horizontal_fit_parameters, vertical_fit_parameters)

    def _update_fits_single(self, horizontal_fit, vertical_fit):
        self._fits_single = self._Fits(self._unpack_fit(horizontal_fit), self._unpack_fit(vertical_fit))

    def _update_fits(self, horizontal_fit, vertical_fit):
        self._fits = self._Fits(self._unpack_fit(horizontal_fit), self._unpack_fit(vertical_fit))

    def _update_fits_calibrated_in_nm_single(self, horizontal_fit, vertical_fit):
        self._fits_calibrated_in_nm_single = self._Fits(self._unpack_fit(horizontal_fit),
                                                        self._unpack_fit(vertical_fit))

    def _update_fits_calibrated_in_nm(self, horizontal_fit, vertical_fit):
        self._fits_calibrated_in_nm = self._Fits(self._unpack_fit(horizontal_fit), self._unpack_fit(vertical_fit))

    def _update_fits_calibrated_in_ev_single(self, horizontal_fit, vertical_fit):
        self._fits_calibrated_in_ev_single = self._Fits(self._unpack_fit(horizontal_fit),
                                                        self._unpack_fit(vertical_fit))

    def _update_fits_calibrated_in_ev(self, horizontal_fit, vertical_fit):
        self._fits_calibrated_in_ev = self._Fits(self._unpack_fit(horizontal_fit), self._unpack_fit(vertical_fit))

    def _unpack_fit(self, fit):
        if fit is None:
            return None
        return self._Data(*fit)

    def _update_fit_parameters_single(self, horizontal_fit_parameters, vertical_fit_parameters):
        self._parameters_single = self._Fits(self._unpack_fit_parameters(horizontal_fit_parameters),
                                             self._unpack_fit_parameters(vertical_fit_parameters))

    def _update_fit_parameters(self, horizontal_fit_parameters, vertical_fit_parameters):
        self._parameters = self._Fits(self._unpack_fit_parameters(horizontal_fit_parameters),
                                      self._unpack_fit_parameters(vertical_fit_parameters))

    def _update_fit_parameters_calibrated_in_nm_single(self, horizontal_fit_parameters, vertical_fit_parameters):
        self._parameters_calibrated_in_nm_single = self._Fits(self._unpack_fit_parameters(horizontal_fit_parameters),
                                                              self._unpack_fit_parameters(vertical_fit_parameters))

    def _update_fit_parameters_calibrated_in_nm(self, horizontal_fit_parameters, vertical_fit_parameters):
        self._parameters_calibrated_in_nm = self._Fits(self._unpack_fit_parameters(horizontal_fit_parameters),
                                                       self._unpack_fit_parameters(vertical_fit_parameters))

    def _update_fit_parameters_calibrated_in_ev_single(self, horizontal_fit_parameters, vertical_fit_parameters):
        self._parameters_calibrated_in_ev_single = self._Fits(self._unpack_fit_parameters(horizontal_fit_parameters),
                                                              self._unpack_fit_parameters(vertical_fit_parameters))

    def _update_fit_parameters_calibrated_in_ev(self, horizontal_fit_parameters, vertical_fit_parameters):
        self._parameters_calibrated_in_ev = self._Fits(self._unpack_fit_parameters(horizontal_fit_parameters),
                                                       self._unpack_fit_parameters(vertical_fit_parameters))

    def _unpack_fit_parameters(self, fit_parameters):
        if fit_parameters is None:
            return self._Parameters(np.nan, np.nan, np.nan, np.nan, np.nan)
        fwhm = 2 * np.sqrt(2 * np.log(2)) * fit_parameters[-1]
        return self._Parameters(*fit_parameters[:-1], fwhm)

    def update_from_single(self):
        self._fits = self._fits_single
        self._fits_calibrated_in_nm = self._fits_calibrated_in_nm_single
        self._fits_calibrated_in_ev = self._fits_calibrated_in_ev_single
        self._parameters = self._parameters_single
        self._parameters_calibrated_in_nm = self._parameters_calibrated_in_nm_single
        self._parameters_calibrated_in_ev = self._parameters_calibrated_in_ev_single
