"""Module with read-only class as a base class for constant class attributes.

This module provides a base class for read-only class attributes.
"""


class ReadOnly(type):
    """ReadOnly class as a base class for constant class attributes.

    This class provides a base class for constant class attributes.
    """

    def __setattr__(cls, key, value):
        """Special method to make the attributes of the class deriving from ReadOnly read-only. """
        raise AttributeError("cannot set attribute")

    def __str__(cls):
        """Special method to return a properly formatted string representation of a ReadOnly subclass."""
        constant_strings = []
        for constant in [constant for constant in dir(cls) if not constant.startswith("__")]:
            constant_strings.append(constant)
        return str(cls.__name__) + "(" + ", ".join(constant_strings) + ")"
