"""Module with typical physical constants for calculation purposes.

This module provides typical physical constants in SI units for calculation purposes.
"""
from doocspie.util.readonly import ReadOnly


class Constants(metaclass=ReadOnly):
    """Read-only Constants class with typical physical constants in SI units.

    This class provides typical physical constants from https://pml.nist.gov/cuu/Constants/.
    """
    ELECTRON_MASS = 9.1093837015e-31
    ELEMENTARY_CHARGE = 1.602176634e-19
    PLANCK_CONSTANT = 6.62607015e-34
    SPEED_OF_LIGHT = 299792458
    VACUUM_PERMEABILITY = 1.25663706212e-6
    VACUUM_PERMITTIVITY = 8.8541878128e-12
