"""Module with convenient color palettes for plotting purposes.

This module provides convenient color palettes via class attributes for plotting purposes.
"""
from doocspie.util.readonly import ReadOnly


class DESY(metaclass=ReadOnly):
    """Read-only DESY class with DESY corporate design color palette.

    This class provides the DESY corporate design color palette.
    """
    CYAN = 0, 159 / 255, 223 / 255
    ORANGE = 241 / 255, 143 / 255, 31 / 255
    BLACK = 76 / 255, 78 / 255, 86 / 255
    WHITE = 1, 1, 1
    RED = 230 / 255, 65 / 255, 35 / 255
    DARK_RED = 153 / 255, 0, 0
    GREEN = 0, 168 / 255, 62 / 255
    LIGHT_GREEN = 122 / 255, 158 / 255, 31 / 255
    DARK_BLUE = 0, 74 / 255, 110 / 255
    YELLOW = 230 / 255, 169 / 255, 15 / 255
    MAGENTA = 208 / 255, 0, 111 / 255
    VIOLET = 146 / 255, 124 / 255, 184 / 255
    PURPLE = 82 / 255, 78 / 255, 156 / 255
    OLIVE = 158 / 255, 150 / 255, 0
    DARK_OLIVE = 89 / 255, 98 / 255, 29 / 255
    LIGHT_BROWN = 170 / 255, 132 / 255, 106 / 255
    DARK_BROWN = 133 / 255, 88 / 255, 62 / 255
    TURQUOISE = 45 / 255, 164 / 255, 164 / 255
    PETROL = 0, 106 / 255, 133 / 255
    AUBERGINE = 139 / 255, 60 / 255, 126 / 255
    LIGHT_GRAY_1 = 202 / 255, 202 / 255, 200 / 255
    LIGHT_GRAY_2 = 183 / 255, 184 / 255, 185 / 255
    LIGHT_GRAY_3 = 173 / 255, 174 / 255, 176 / 255
    GRAY_1 = 147 / 255, 149 / 255, 152 / 255
    GRAY_2 = 122 / 255, 125 / 255, 129 / 255
    DARK_GRAY = 122 / 255, 125 / 255, 129 / 255
    ANTHRACITE = 91 / 255, 93 / 255, 98 / 255


class Tango(metaclass=ReadOnly):
    """ReadOnly Tango class with Tango desktop project color palette.

    This class provides the Tango desktop project color palette.
    """
    SCARLET_RED_1 = 239 / 255, 41 / 255, 41 / 255
    SCARLET_RED_2 = 204 / 255, 0, 0
    SCARLET_RED_3 = 164 / 255, 0, 0
    SKY_BLUE_1 = 114 / 255, 159 / 255, 207 / 255
    SKY_BLUE_2 = 52 / 255, 101 / 255, 164 / 255
    SKY_BLUE_3 = 32 / 255, 74 / 255, 135 / 255
    CHAMELEON_1 = 138 / 255, 226 / 255, 52 / 255
    CHAMELEON_2 = 115 / 255, 210 / 255, 22 / 255
    CHAMELEON_3 = 78 / 255, 154 / 255, 6 / 255
    PLUM_1 = 173 / 255, 127 / 255, 168 / 255
    PLUM_2 = 117 / 255, 80 / 255, 123 / 255
    PLUM_3 = 92 / 255, 53 / 255, 102 / 255
    CHOCOLATE_1 = 233 / 255, 185 / 255, 110 / 255
    CHOCOLATE_2 = 193 / 255, 125 / 255, 17 / 255
    CHOCOLATE_3 = 143 / 255, 89 / 255, 2 / 255
    ORANGE_1 = 252 / 255, 175 / 255, 62 / 255
    ORANGE_2 = 245 / 255, 121 / 255, 0
    ORANGE_3 = 206 / 255, 92 / 255, 0
    BUTTER_1 = 252 / 255, 233 / 255, 79 / 255
    BUTTER_2 = 237 / 255, 212 / 255, 0
    BUTTER_3 = 196 / 255, 160 / 255, 0
    ALUMINIUM_1 = 238 / 255, 238 / 255, 236 / 255
    ALUMINIUM_2 = 211 / 255, 215 / 255, 207 / 255
    ALUMINIUM_3 = 186 / 255, 189 / 255, 182 / 255
    ALUMINIUM_4 = 136 / 255, 138 / 255, 133 / 255
    ALUMINIUM_5 = 85 / 255, 87 / 255, 83 / 255
    ALUMINIUM_6 = 46 / 255, 52 / 255, 54 / 255


class Colors(metaclass=ReadOnly):
    """ReadOnly Colors class aggregating the actual color palettes.

    This class aggregates the actual color palettes.
    """
    DESY = DESY
    Tango = Tango
