"""Module with message dialogs for convenient working with PyQt GUI applications.

This module provides the message dialogs for convenient working with PyQt GUI applications.
"""
from PyQt5.QtWidgets import QMessageBox


def show_error(message):
    """Showing a PyQt error dialog with a given message.

    Args:
        message (str): The message to show in the PyQt error dialog.

    Returns:
        None
    """
    _show_message_box(message, QMessageBox.Critical)


def show_warning(message):
    """Showing a PyQt warning dialog with a given message.

    Args:
        message (str): The message to show in the PyQt warning dialog.

    Returns:
        None
    """
    _show_message_box(message, QMessageBox.Warning)


def _show_message_box(message, icon):
    """Helper function to show a message box with a given message and icon."""
    message_box = QMessageBox(icon=icon)
    message_box.setText(message)
    message_box.exec_()


def show_about(application_ui, application_name, application_version):
    """Showing a PyQt about dialog of a given application with its name and version.

    Args:
        application_ui (subclass of QMainWindow): The application's PyQt ui.
        application_name (str): The application's name.
        application_version (str): The application's version number.

    Returns:
        None
    """
    QMessageBox.about(application_ui, application_name, "Version " + application_version)
