"""Module with e-log data class for generating e-log entries.

This module provides the e-log data class for generating properly formatted e-log entries.
"""
import dataclasses
from typing import Dict


@dataclasses.dataclass
class ELogData:
    """E-log data class for generating properly formatted e-log entries.

    This data class provides the attributes and method to generate properly formatted e-log entries.
    """
    printers: Dict[str, str]

    printer: str = None

    to_print: bool = None

    author: str = None
    title: str = None
    severity: str = None
    text: str = None
    image: str = None

    def get_e_log_entry(self):
        """Getting the e-log entry in a properly formatted xml string.

        Returns:
            str: The e-log entry in a properly formatted xml string.
        """
        e_log_xml_string_list = ["<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>", "<entry>",
                                 "<author>", self.author, "</author>",
                                 "<title>", self.title, "</title>",
                                 "<severity>", self.severity, "</severity>",
                                 "<text>", self.text.replace("<", "&lt;").replace(">", "&gt;"), "</text>",
                                 "<image>", self.image, "</image>", "</entry>"]
        return "\n".join(e_log_xml_string_list).encode()
