"""Module with concurrency support for convenient working with PyQt GUI applications.

This module provides the concurrency support for convenient working with PyQt GUI applications.
"""
from PyQt5.QtCore import QTimer


class Timer:
    """Timer class for higher level concurrency support for PyQt.

    This class provides the higher level concurrency support for Timers in PyQt.
    """

    def __init__(self, function, interval=0):
        """Constructor of the timer class.

        This constructor initializes the instance with the function to repeatedly carry out.

        Args:
            function (function): The function to repeatedly carry out.
            interval (int): The time interval for the repetition in milliseconds.
        """
        self._function = function
        self._interval = interval
        self._timer = QTimer()

    def start(self):
        """Start the timer with its associated function.

        Returns:
            None
        """
        self._timer.timeout.connect(self._function)
        self._timer.start(self._interval)

    def stop(self):
        """Stop the timer with its associated function.

        Returns:
            None
        """
        self._timer.stop()
        self._timer.timeout.disconnect(self._function)

    def is_active(self):
        """Return the timer's activity state.

        Returns:
            bool: The state of the timer's activity.
        """
        return self._timer.isActive()
