"""Module with metaclass for metadata provided by DOOCS.

This module provides the metaclass for metadata provided by the DOOCS control system.
"""


class Meta:
    """Metaclass for metadata provided by DOOCS.

    This class provides the metadata provided by the DOOCS control system.
    """

    def __init__(self, miscellaneous):
        """Constructor of the metaclass.

        This constructor initializes the instance using the miscellaneous data from pydoocs.

        Args:
            miscellaneous (dict): The miscellaneous data provided by pydoocs.
        """
        for key, value in miscellaneous.items():
            self.__dict__[key] = value

    def __setattr__(self, name, value):
        """Special method to make the meta properties read-only."""
        raise AttributeError("cannot set attribute")

    def __str__(self):
        """Special method to return a properly formatted string representation of the metadata."""
        meta_strings = []
        for key, value in self.__dict__.items():
            meta_strings.append(str(key) + "=" + repr(value))
        return self.__class__.__name__ + "(" + ", ".join(meta_strings) + ")"

    def __len__(self):
        """Special method to return the number of properties."""
        return len(self.__dict__)

    def __eq__(self, other):
        """Special method to check for equality by using the '==' operator."""
        if isinstance(other, Meta):
            return self.__dict__ == other.__dict__
        return False
