"""DOOCS Python Interface for Experiments.

This module provides the basic functions for I/O operations with the DOOCS control system as well as
subpackages for recurrent tasks when performing experiments and evaluating data with Python within the context
of DOOCS.
"""
import os

from doocspie import abo, core, daq, doocspie, gui, pyqt, util
from doocspie.doocspie import DoocspieException

# The "#:" in the following comments marks a "sphinx" doc string.

with open(os.path.dirname(os.path.abspath(__file__)) + "/VERSION") as file:
    #: The doocspie version number.
    __version__ = file.read().strip()

#: The version number of pydoocs, which represents the core of doocspie.
__pydoocs_version__ = core.__version__

#: The version number of DOOCS, which is the underlying control system.
__doocs_libno__ = core.__LIBNO__


# make the main functions from doocspie.doocspie.io directly available in doocspie,
# so they also show up in the docstring generated by help(doocspie)

def ls(address):
    return doocspie.io.ls(address)


def get(address, event=None, ignore_event_mismatch=False, timestamp_event=False, meta_event=None, start=None,
        elements=None):
    return doocspie.io.get(address, event, ignore_event_mismatch, timestamp_event, meta_event, start, elements)


def set(address, value, allow_resizing=False):
    return doocspie.io.set(address, value, allow_resizing=allow_resizing)


def get_history(address, begin=None, end=None):
    return doocspie.io.get_history(address, begin=begin, end=end)


# re-use the docstring directly from doocspie.doocspie.io, where they actually get documented

ls.__doc__ = doocspie.io.ls.__doc__
get.__doc__ = doocspie.io.get.__doc__
set.__doc__ = doocspie.io.set.__doc__
get_history.__doc__ = doocspie.io.get_history.__doc__
